/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2005 by Myricom, Inc.  All rights reserved.                 *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx_timing.h"
#include "mx_debug.h"
#include <stdio.h>
#include <stdlib.h>
#if !MX_OS_WINNT
#include <unistd.h>
#include <sys/time.h>
#endif

static int
cmp_uint64(const void *ap,const void*bp)
{
  const mx_cycles_t *a = ap, *b = bp;
  return (*a == *b) ? 0 : (*a > *b) ? 1 : -1;
}

static mx_cycles_t cycles_per_second;
static double seconds_per_cycle;

#if !MX_OS_WINNT
#undef mx_cycles_per_second
#undef mx_seconds_per_cycle
mx_cycles_t mx_cycles_per_second(void)
{
  if (!cycles_per_second) {
    mx_cycles_counter_init();
    if (!cycles_per_second)
      mx_fatal("mx_cycles_per_second:gcc-compiled app with non-gcc lib");
  }
  return cycles_per_second;
}

double mx_seconds_per_cycle(void)
{
  if (!cycles_per_second) {
    mx_cycles_counter_init();
    if (!cycles_per_second)
      mx_fatal("mx_seconds_per_cycles:gcc-compiled app with non-gcc lib");
  }
  return seconds_per_cycle;
}
#endif

#define NB_ITER 4
void mx_cycles_counter_init(void)
{
#if (defined __GNUC__ && !(MX_CPU_sparc || MX_CPU_sparc64)) || MX_OS_SOLARIS
  mx_cycles_t cpc[NB_ITER];
  mx_cycles_t t1,t2;
  struct timeval tv1,tv2;
  int i;
  char *env;

  env = getenv("MX_CYCLES_PER_SECOND");
  if (env) {
    sscanf(env,"%"PRId64,&cycles_per_second);
    if (cycles_per_second) {
      seconds_per_cycle = 1.0 / cycles_per_second;
      return;
    }
  }
  for (i=0;i<NB_ITER;i++) {
    t1 = mx_get_cycles();
    gettimeofday(&tv1,0);
    usleep(200000);
    t2 = mx_get_cycles();
    gettimeofday(&tv2,0);
    cpc[i] = ((t2-t1)*1000000ULL)/((tv2.tv_sec-tv1.tv_sec)*1000000ULL+tv2.tv_usec-tv1.tv_usec);
  }
  qsort(cpc,NB_ITER,sizeof(mx_cycles_t),cmp_uint64);
  cycles_per_second = cpc[2];
  seconds_per_cycle = 1.0 / cycles_per_second;
#endif
}

#if MX_OS_SOLARIS && !defined(MX_KERNEL)

#if MX_CPU_x86_64
void mx__dummy_cycles(void)
{
  asm(".globl mx__get_cycles\n\t"
      "mx__get_cycles:\n\t"
      "rdtsc\n\t"
      "shlq    $32, %rdx\n\t"
      "orq     %rdx, %rax\n\t"
      "ret\n");
}
#elif MX_CPU_x86
void mx__dummy_cycles(void)
{
  asm(".globl mx__get_cycles\n\t"
      "mx__get_cycles:\n\t"
      "rdtsc\n\t"
      "ret\n");
}
#else
mx_cycles_t mx__get_cycles(void)
{
  return gethrtime();
}
#endif


#endif /* solaris */

